---
generated_at: 2026-02-01 17:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-AIR（Abstract IR）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Air.zig` - ファイル先頭コメント（1-6行目）
- E-02: `src/Air.zig` - instructionsフィールド（22行目）
- E-03: `src/Air.zig` - extraフィールド（25行目）
- E-04: `src/Air.zig` - ExtraIndex列挙型（27-32行目）
- E-05: `src/Air.zig` - Inst構造体（34-36行目）
- E-06: `src/Air.zig` - Tag列挙型（38-300行目）
- E-07: `src/Air.zig` - arg命令（43行目）
- E-08: `src/Air.zig` - add命令（48行目）
- E-09: `src/Air.zig` - add_safe命令（55行目）
- E-10: `src/Air.zig` - alloc命令（221行目）
- E-11: `src/Air.zig` - block命令（284行目）
- E-12: `src/Air.zig` - loop命令（294行目）
- E-13: `src/Air.zig` - br命令（300行目）
- E-14: `src/Air.zig` - Legalize, Livenessのimport（19-20行目）
- E-15: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.46の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AIRはSemaで生成されcodegenで消費 | E-01 | ○ |
| C-02 | ZIRは1ファイル1インスタンス、AIRは1関数1インスタンス | E-01 (5行目) | ○ |
| C-03 | instructionsフィールドで命令リスト保持 | E-02 | ○ |
| C-04 | extraフィールドで追加データ保持 | E-03 | ○ |
| C-05 | Inst構造体でtag, data保持 | E-05 | ○ |
| C-06 | Tag列挙型で命令種別定義 | E-06 | ○ |
| C-07 | arg命令で関数引数表現 | E-07 | ○ |
| C-08 | add命令で加算表現 | E-08 | ○ |
| C-09 | add_safe命令で安全性チェック付き加算 | E-09 | ○ |
| C-10 | alloc命令でスタック割り当て | E-10 | ○ |
| C-11 | block命令でブロック表現 | E-11 | ○ |
| C-12 | loop命令でループ表現 | E-12 | ○ |
| C-13 | br命令でブレイク表現 | E-13 | ○ |
| C-14 | Liveness, Legalizeモジュールが存在 | E-14 | ○ |
| C-15 | Air.zigは約104KB | ファイルサイズ確認済み | ○ |
| C-16 | 機能一覧にNo.46として定義 | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Air構造体のフィールド定義を確認
- [ ] Tag列挙型の命令種別を確認
- [ ] Livenessモジュールの役割を確認
- [ ] Legalizeモジュールの役割を確認
